@extends('layouts.admin')

@section('title', 'View Contact Message')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Message</h1>
    <div class="d-flex gap-2">
        @if($contactMessage->is_read)
            <form action="{{ route('admin.contact-messages.markAsUnread', $contactMessage) }}" method="POST" class="d-inline">
                @csrf
                @method('PATCH')
                <button type="submit" class="btn btn-warning">
                    <i class="bi bi-envelope"></i> Mark as Unread
                </button>
            </form>
        @else
            <form action="{{ route('admin.contact-messages.markAsRead', $contactMessage) }}" method="POST" class="d-inline">
                @csrf
                @method('PATCH')
                <button type="submit" class="btn btn-success">
                    <i class="bi bi-envelope-check"></i> Mark as Read
                </button>
            </form>
        @endif
        <a href="{{ route('admin.contact-messages.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>Name:</strong>
                <p>{{ $contactMessage->name }}</p>
            </div>
            <div class="col-md-6">
                <strong>Email:</strong>
                <p><a href="mailto:{{ $contactMessage->email }}">{{ $contactMessage->email }}</a></p>
            </div>
        </div>

        @if($contactMessage->subject)
        <div class="mb-3">
            <strong>Subject:</strong>
            <p>{{ $contactMessage->subject }}</p>
        </div>
        @endif

        <div class="mb-3">
            <strong>Message:</strong>
            <p class="mt-2">{{ $contactMessage->message }}</p>
        </div>

        <div class="row">
            <div class="col-md-6">
                <strong>Status:</strong>
                <p>
                    <span class="badge bg-{{ $contactMessage->is_read ? 'success' : 'warning' }}">
                        {{ $contactMessage->is_read ? 'Read' : 'Unread' }}
                    </span>
                </p>
            </div>
            <div class="col-md-6">
                <strong>Received:</strong>
                <p>{{ $contactMessage->created_at->format('M d, Y h:i A') }}</p>
            </div>
        </div>

        <hr>

        <form action="{{ route('admin.contact-messages.destroy', $contactMessage) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this message?');">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger">
                <i class="bi bi-trash"></i> Delete Message
            </button>
        </form>
    </div>
</div>
@endsection



